var decoder = require('../decoder_vb_rev-12.js');

var bootPattern = [0x31, 0x01, 0x03];
var activated = [0x35, 0x06, 0x08, 0x01, 0x02, 0x03, 0x04, 0x05];
var deactivated = [0x36, 0x02, 0x00];
var deviceStatusPattern = [0x32, 0x75, 0x15, 0x03, 0x00, 0x02, 0x06, 0x01, 0x07];
var sensorEventPattern = [0x33, 0x00, 0x95, 0x01, 0x00, 0xD2, 0x04, 0x88, 0x13, 0x02, 0x00, 0xD3, 0x04, 0x87, 0x13,
  0x03, 0x00, 0xD4, 0x04, 0x86, 0x13, 0x04, 0x00, 0xD5, 0x04, 0x85, 0x13, 0x05, 0x00, 0xD6, 0x04, 0x84, 0x13,
  0x06, 0x00, 0xD7, 0x04, 0x83, 0x13, 0x61, 0xF0, 0xD2, 0x04, 0x40, 0x1F];
var sensorDataPattern = [0x34,
  0x43, 0x99, 0x44, 0x06, 0x02, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 
  0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E,  0x1F, 0x20,
  0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,];
var baseConfigPattern = [0x30, 0x12, 0x34, 0x56, 0x78, 0x01];
var regionConfigPattern = [0x31, 0x12, 0x34, 0x56, 0x78, 0x01];
var sensorConfigPattern = [0x33, 0x12, 0x34, 0x56, 0x78, 0x01];
var sensorConditionsConfigPattern = [0x35, 0x12, 0x34, 0x56, 0x78, 0x01];

function decode(tag, fPort, bytestring) {
  console.log("###### " + tag)
  console.log(`FPort: ${fPort}`)
  console.log("Bytestring (hexidecimal):")
  console.log("```")
  console.log(Buffer.from(bytestring).toString('hex'))
  console.log("```")
  var object = decoder.decodeUplink({fPort: fPort, bytes: bytestring});
  console.log("JSON:")
  console.log("```json")
  console.log(JSON.stringify(object, null, 4))
  console.log("```")
}

console.log("##### Decoding")
decode("Boot message", 1, bootPattern)
decode("Activated message", 5, activated)
decode("Deactivated message", 6, deactivated)
decode("Device status message", 2, deviceStatusPattern)
decode("Sensor event message", 3, sensorEventPattern)
decode("Sensor data message", 4, sensorDataPattern)
decode("Base config answer", 7, baseConfigPattern)
decode("Region config answer", 7, regionConfigPattern)
decode("Sensor config answer", 7, sensorConfigPattern)
decode("Sensor conditions config answer", 7, sensorConditionsConfigPattern)
